local assets=
{
	Asset("ANIM", "anim/nightmaresword.zip"),
	Asset("ANIM", "anim/swap_nightmaresword.zip"),
    
}

local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_nightmaresword", "swap_nightmaresword")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("nightmaresword")
    inst.AnimState:SetBuild("nightmaresword")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetMultColour(1, 1, 1, 0.6)
    
    inst:AddTag("shadow")
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.NIGHTSWORD_DAMAGE)
    
    -------

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")

	
	
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
	
	
		inst:AddComponent("dapperness")
		inst.components.dapperness.dapperness = TUNING.DAPPERNESS_SMALL
	
		local ownertag = "waxwell"
		local function undropppable(inst)
					--local found = false
				local owner1 = FindEntity(inst, 1, function(guy) return (guy:HasTag("player3") and guy:HasTag(ownertag) and not guy.components.health:IsDead())end)
				if owner1 then
					local action = ACTIONS.PICKUP 
					local ba = BufferedAction(owner1, inst, action)
					owner1.components.locomotor:PushAction(ba, true)
				end

				
				inst:DoTaskInTime(0.5, function() 
					if inst.components.inventoryitem and inst.components.inventoryitem.owner and inst.components.inventoryitem.owner==nil then
						inst:Remove()
					elseif not owner1 then
						inst:Remove()
					end
				end)
		end
		inst:DoPeriodicTask(10, function()
			inst.components.inventoryitem:ChangeImageName("nightsword")

			if inst.components.inventoryitem and inst.components.inventoryitem.owner and inst.components.inventoryitem.owner==GetPlayer() then
				inst:Remove()
			end
		end)
		inst:AddTag("specialitemplayer3")
		inst:ListenForEvent("ondropped", undropppable) 
		inst.components.inventoryitem:ChangeImageName("nightsword")
	
	
	
	
    return inst
end

return Prefab( "common/inventory/nightsword_player3", fn, assets) 
